<?php

define('LANIAKEA_THEME_VERSION', '1.0');
define('LANIAKEA_THEME_DIR', trailingslashit(get_template_directory()));
define('LANIAKEA_THEME_URI', trailingslashit(esc_url(get_template_directory_uri())));
define('LANIAKEA_MAINTENANCE_MODE', false);
define('LANIAKEA_GFONT_APIKEY', 'AIzaSyB_IDts3fy_LJC9CacWooGOXWX3y8f2cWM');

require_once LANIAKEA_THEME_DIR . 'core/tgmpa/tgmpa-activation.php';
require_once LANIAKEA_THEME_DIR . 'core/helper-functions.php';
require_once LANIAKEA_THEME_DIR . 'core/theme-sidebars.php';
require_once LANIAKEA_THEME_DIR . 'core/custom-posts.php';
require_once LANIAKEA_THEME_DIR . 'core/svg-support.php';
require_once  LANIAKEA_THEME_DIR . 'core/shortcodes/shortcodes.php';
require_once LANIAKEA_THEME_DIR . 'core/iubenda-menu-item.php';

/* //WPCF7 INTEGRATIONS:
require_once LANIAKEA_THEME_DIR . 'core/wpcf7-integrations.php';
 */




//ADMIN PAGE
if (is_admin()) {
    
    require_once LANIAKEA_THEME_DIR . 'core/admin/admin-configs.php';
    require_once LANIAKEA_THEME_DIR . 'core/admin/admin-page.php';
    require_once LANIAKEA_THEME_DIR . 'core/post-meta-box.php';
}

function laniakea_admin_bar_item(WP_Admin_Bar $wp_admin_bar)
{

    $wp_admin_bar->add_menu(
        array(
            'id'     => 'laniakea-options-page',
            'parent' => null, // use 'top-secondary' for toggle menu position.
            'href'   => admin_url('admin.php?page=laniakea-options'),
            'title'  => '<span class="laniakea-icon"></span>Opzioni Tema',
        )
    );
}
add_action('admin_bar_menu', 'laniakea_admin_bar_item', 100);

function laniakea_enqueue_scripts()
{
    wp_enqueue_style('fontawesome-style', LANIAKEA_THEME_URI . '/core/assets/fontawesome/css/all.min.css', array());
    wp_enqueue_style('swiper-style',  LANIAKEA_THEME_URI . '/core/assets/swiper/swiper-bundle.min.css', array(), '11.0.5');
    wp_enqueue_style('laniakea-style',  LANIAKEA_THEME_URI . '/style.min.css', array('fontawesome-style'));

    wp_enqueue_script('laniakea-scripts',  LANIAKEA_THEME_URI . '/core/assets/js/scripts.js', array('jquery'), '1.1', true);
    wp_enqueue_script('swiper-scripts',  LANIAKEA_THEME_URI . '/core/assets/swiper/swiper-bundle.min.js', array(), '11.0.5', true);


    // Inline styles
    add_filter('laniakea-inline-style', 'laniakea_dynamic_style');
    $theme_dynamic_css = apply_filters('laniakea-inline-style', '');
    wp_register_style('laniakea-dyna-style', false);
    wp_enqueue_style('laniakea-dyna-style');
    wp_add_inline_style('laniakea-dyna-style', $theme_dynamic_css);
}
add_action('wp_enqueue_scripts', 'laniakea_enqueue_scripts', 99);

function laniakea_enqueue_admin_scripts()
{   //fontawesome css
    wp_enqueue_style('fontawesome-style', LANIAKEA_THEME_URI . '/core/assets/fontawesome/css/all.min.css', array());

    wp_enqueue_style('laniakea-admin-style', LANIAKEA_THEME_URI . '/laniakea-admin.css', array());
    wp_enqueue_script('laniakea-admin-scripts', LANIAKEA_THEME_URI . '/core/assets/js/admin.js', array(), '1.0', true);

    //ace js
    wp_enqueue_script('laniakea-ace-scripts', LANIAKEA_THEME_URI . '/core/assets/ace/ace.js', array(), '1.0', false);
}
add_action('admin_enqueue_scripts', 'laniakea_enqueue_admin_scripts');

add_action('after_setup_theme', 'laniakea_setup');
function laniakea_setup()
{

    // Add multilanguage support
    load_theme_textdomain('laniakea', LANIAKEA_THEME_DIR . 'languages');

    // Add theme support for feed links
    add_theme_support('automatic-feed-links');

    // Manage the document title tag
    add_theme_support('title-tag');

    // Add theme support for menus
    if (function_exists('register_nav_menus')) {
        register_nav_menus(
            array(
                'laniakea-pre-header-menu' => 'Pre Header Menu',
                'laniakea-header-menu' => 'Header Menu',
                'laniakea-footer-menu' => 'Footer Menu',
            )
        );
    }

    // Enable support for Blog Posts Thumbnails
    add_theme_support('post-thumbnails');

    // Selective Refresh Support for Widgets
    add_theme_support('customize-selective-refresh-widgets');

    // Enable support for WooCommerce
    add_theme_support('woocommerce', array(
        'thumbnail_image_width' => 400,
        'gallery_thumbnail_image_width' => 400,
        'single_image_width' => 800,
    ));
    add_theme_support('wc-product-gallery-lightbox');

    // Switch default core markup for search form, comment form, and comments to output valid HTML5.
    add_theme_support('html5', array(
        'style',
        'script',
    ));

    // Remove block-based widget support
    remove_theme_support('widgets-block-editor');
}

// ------------------------------------------------------------------------
// Content Width
// ------------------------------------------------------------------------


function laniakea_set_content_width()
{
    if (!isset($content_width)) {
        $content_width = laniakea_option('content_width', 1300);
    }
}

add_action('wp', 'laniakea_set_content_width');

// ------------------------------------------------------------------------
// Blog functionality
// ------------------------------------------------------------------------

// Custom blog navigation
function laniakea_blog_prev_link($output)
{
    return str_replace('<a href=', '<a class="prev" href=', $output);
}
add_filter('previous_post_link', 'laniakea_blog_prev_link');

function laniakea_blog_next_link($output)
{
    return str_replace('<a href=', '<a class="next" href=', $output);
}
add_filter('next_post_link', 'laniakea_blog_next_link');

// Excerpt length
function laniakea_excerpt_length($length)
{
    return 23;
}
add_filter('excerpt_length', 'laniakea_excerpt_length');


if (class_exists('WPBakeryShortCode')) {
    if (!function_exists('laniakea_vc_set_as_theme')) {
        function laniakea_vc_set_as_theme()
        {
            vc_set_as_theme($disable_updater = true);
        }
    }
}
add_action('vc_before_init', 'laniakea_vc_set_as_theme');

function LANIAKEA_MAINTENANCE_MODE($template)
{
    $maintenance_mode = LANIAKEA_MAINTENANCE_MODE;
    $new_template = locate_template(array('maintenance-page-template.php'));
    if ($maintenance_mode && !is_user_logged_in()) {
        return $new_template;
    }
    return $template;
}
add_action('template_include', 'LANIAKEA_MAINTENANCE_MODE', 1);


function laniakea_dynamic_style()
{
    ob_start();
    include_once(LANIAKEA_THEME_DIR . 'core/dynamic-styles.php');
    $dynamic_css = ob_get_clean();
    $dynamic_css = laniakea_compress_css($dynamic_css);
    return $dynamic_css;
}
