<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
get_header();

$laniakea_show_header = get_post_meta($post->ID, 'laniakea_show_header', true);
$laniakea_header_title = get_post_meta($post->ID, 'laniakea_header_title', true);

$laniakea_header_bg = get_post_meta($post->ID, 'laniakea_header_bg', true);
$styles = "background-color:$laniakea_header_bg;";
if (has_post_thumbnail()) {
    $bg_image = get_the_post_thumbnail_url();
    $styles = "background-image:url($bg_image)";
}
?>

<?php if ($laniakea_show_header == 1) : ?>
    <section class="laniakea-header <?php echo has_post_thumbnail() ? 'has-image' : ''; ?>" style="<?php echo $styles; ?>">
        <div class="header-container contained">
            <h1 class="title"><?php echo $laniakea_header_title; ?></h1>
        </div>
    </section>
<?php endif; ?>

<section id="site-content" class="contained">

    <main>
        <?php if (have_posts()) :
            while (have_posts()) :
                the_post();
                the_content();
            endwhile;
        endif;
        ?>

    </main>
</section>
<?php get_footer(); ?>