<?php
$primary_color = laniakea_option('primary_color', '#5f68dd');
$primary_text_color = laniakea_option('primary_text_color', '#333333');

$stickybar_side = laniakea_option('stickybar_side', 'right');
$show_stickybar = laniakea_option('show_stickybar');
$stickybar_top = laniakea_option('stickybar_top', '30%');
$bakery_buttons = laniakea_bakery_btn_colors();

$archive_count = laniakea_option('archive_grid_count');
$search_count = laniakea_option('search_grid_count');
$category_count = laniakea_option('category_grid_count');

$archive_col_gap = laniakea_option('archive_grid_gap');
$search_col_gap = laniakea_option('search_grid_gap');
$category_col_gap = laniakea_option('category_grid_gap');
$menu_padding_top = laniakea_option('menu_padding_top', 24);
$menu_padding_bottom = laniakea_option('menu_padding_bottom', 24);

$hf = 250 + $menu_padding_top + $menu_padding_bottom;
$wrapper_min_height = 'calc( 100vh - ' . $hf . 'px )';
?>
:root{
--primary-color : <?php echo $primary_color; ?>;
}

.contained{
max-width : <?php echo laniakea_option('content_width', 1300); ?>px;
}

#wrapper{
min-height:<?php echo $wrapper_min_height; ?>;
}

body,
#wrapper h1,
#wrapper h2,
#wrapper h3,
#wrapper h4,
#wrapper h5,
#wrapper h6
{
font-family: <?php echo laniakea_option('global_font', 'Raleway') ?>, sans-serif !important;
}
<?php for ($i = 1; $i < 6; $i++) : ?>
    <?php
    $size = laniakea_option('h' . $i . '_size');
    $line_height = laniakea_option('h' . $i . '_line_height');
    ?>
    h<?php echo $i; ?>{
    <?php if (!empty($size)) : ?>font-size : <?php echo $size ?>;<?php endif; ?>
    <?php if (!empty($line_height)) : ?>line-height: <?php echo $line_height ?>;<?php endif; ?>
    }
<?php endfor; ?>

p{
<?php if (laniakea_option('paragraph_size')) echo 'font-size:' . laniakea_option('paragraph_size') . ';' ?>
<?php if (laniakea_option('paragraph_line_height')) echo 'line-height:' . laniakea_option('paragraph_line_height') . ';' ?>
color : <?php echo $primary_text_color; ?>;
}


<?php if ($show_stickybar == 1) : ?>
    .laniakea-stickybar{
    <?php echo $stickybar_side ?> : 0px;
    top : <?php echo $stickybar_top; ?>%;
    }
<?php endif; ?>

#main-header #logo{
max-width : <?php echo laniakea_option('logo_maxwidth', 100) ?>px;
}

.laniakea-stickybar a:hover,
.wpcf7 .wpcf7-submit{
background-color : <?php echo $primary_color; ?>;
}

.laniakea-menu li a{
font-weight: <?php echo laniakea_option('menu_font_weight', '700'); ?>;
}

.laniakea-menu li a:hover,
.laniakea-menu li.current-menu-item a,
.laniakea-pre-menu li a:hover,
laniakea-pre-menu li.current-menu-item a {
color: <?php echo laniakea_option('menu_hover_color', '#5f68dd') ?>;
}

@media (min-width: 992px){
.laniakea-menu>ul>li>a {
padding-top : <?php echo $menu_padding_top; ?>px;
padding-bottom :<?php echo $menu_padding_bottom; ?>px;
}
}

footer{
background-color : <?php echo laniakea_option('footer_bgcolor', '#444'); ?>
}
footer *{
color : <?php echo laniakea_option('footer_color', 'silver'); ?>
}
footer .lower-footer{
background-color : <?php echo laniakea_option('lower_footer_bgcolor', '#444'); ?>
}

.captcha-image .cf7ic_instructions span{
color : <?php echo $primary_color; ?>
}



#archive-content main{
<?php if (!empty($archive_count)) :
    $fr = array_fill(0, $archive_count, '1fr');
    $fr = join(' ', $fr);
?>
    grid-template-columns: <?php echo $fr ?>;
<?php endif; ?>
<?php if (!empty($archive_col_gap)) : ?>
    gap : <?php echo $archive_col_gap; ?>px;
<?php endif; ?>
}

#search-content{
<?php if (!empty($search_count)) :
    $fr = array_fill(0, $search_count, '1fr');
    $fr = join(' ', $fr);
?>
    grid-template-columns: <?php echo $fr ?>;
<?php endif; ?>
<?php if (!empty($search_col_gap)) : ?>
    gap : <?php echo $search_col_gap; ?>px;
<?php endif; ?>
}

body.archive.category #archive-content main{
<?php if (!empty($category_count)) :
    $fr = array_fill(0, $category_count, '1fr');
    $fr = join(' ', $fr);
?>
    grid-template-columns: <?php echo $fr ?>;
<?php endif; ?>
<?php if (!empty($category_col_gap)) : ?>
    gap : <?php echo $category_col_gap; ?>px;
<?php endif; ?>
}

#wrapper .vc_btn3:hover{
<?php if (!empty(laniakea_option('bakery_btn_hover_bg'))) : ?>
    background-color:<?php echo laniakea_option('bakery_btn_hover_bg') ?>!important;
<?php endif; ?>
<?php if (!empty(laniakea_option('bakery_btn_hover_color'))) : ?>
    color:<?php echo laniakea_option('bakery_btn_hover_color') ?>!important;;
<?php endif; ?>
}



<?php foreach ($bakery_buttons as $btn) :
    $color = laniakea_option('bakery_btn_color_' . $btn['value']);
    if (
        !empty($color)
        && $color != $btn['default']
    ) :
?>
        #wrapper .vc_btn3.vc_btn3-color-<?php echo $btn['value']; ?>{
        background-color : <?php echo $color; ?>;
        }
<?php endif;
endforeach; ?>

<?php if (is_page()) : global $post; ?>
    .page .has-image:before{
    background-color: <?php echo get_post_meta($post->ID, 'laniakea_header_bg', true); ?>;

    }
<?php endif; ?>


<?php if (!empty(laniakea_option('logo_break'))) : ?>
@media (max-width:<?php echo laniakea_option('logo_break')?>px){
    #main-header #logo{
    max-width : <?php echo laniakea_option('logo_maxwidth_mobile', 100) ?>px;
    }
}
<?php endif; ?>