<?php
add_action('wpcf7_init', 'custom_add_form_tag_clock');

function custom_add_form_tag_clock()
{
    wpcf7_add_form_tag('clock', 'custom_clock_form_tag_handler'); // "clock" is the type of the form-tag
}

function custom_clock_form_tag_handler($tag)
{
    return date_i18n(get_option('time_format'));
}


add_action('wpcf7_admin_init', 'clock_add_tag_generator', 55); // A
function clock_add_tag_generator()
{
    $tag_generator = WPCF7_TagGenerator::get_instance();
    $tag_generator->add(
        'clock',
        'CLOCK',
        'clock_tag_generator',
        array('nameless' => 1)
    );
}

function clock_tag_generator($contact_form, $args = '')
{
    $args = wp_parse_args($args, array()); ?>
    <div class="insert-box">
        <input type="text" name="clock" class="tag code" readonly="readonly" onfocus="this.select()" />
        <div class="submitbox">
            <input type="button" class="button button-primary insert-tag"
                value="<?php echo esc_attr(__('Insert Tag', 'contact-form-7')); ?>" />
        </div>
    </div>
    <?php
}