<?php


//https://swiperjs.com/swiper-api   

$post_type = !empty($this->atts['custom_post']) ? $this->atts['custom_post'] : 'laniakea_swiper';

if (!empty($this->atts['custom_post'])) {
    $args = array(
        'post_type' => $this->atts['custom_post'],
        'post_status' => 'publish',
        'order' => 'ASC',
        'orderby' => 'menu_order',
    );
} else {
    $args = array(
        'post_type' => 'laniakea_swiper',
        'post_status' => 'publish',
        'order' => 'ASC',
        'orderby' => 'menu_order',
        'tax_query' => array(
            array(
                'taxonomy' => 'swiper_group',
                'field' => 'slug',
                'terms' =>  $this->atts['gruppo'],
            )
        ),
    );
}

$the_query = new WP_Query($args);
if ($this->atts['gruppo']) {
    $term = get_term_by('slug',$this->atts['gruppo'],'swiper_group');
    $term_meta = get_option("taxonomy_term_$term->term_id");
    $swiper_json = wp_unslash($term_meta["swiper_group_json"]);
}

if ($the_query->have_posts()) : ?>
    <div class="swiper">
        <div class="swiper-wrapper">
            <?php while ($the_query->have_posts()) :
                $the_query->the_post();
                $link = $post_type == 'laniakea_swiper' ? get_post_meta(get_the_ID(), 'slide_link', true) : get_the_permalink();
            ?>
                <div class="swiper-slide">
                    <div class="card">
                        <?php if (!empty($this->atts['button_text'])) : ?>
                            <div class="vc_btn3-container vc_btn3-inline">
                                <a href="<?php echo $link; ?>" class="vc_general vc_btn3 vc_btn3-size-lg vc_btn3-shape-square vc_btn3-style-flat vc_btn3-color-<?php echo $this->atts['button_color'] ?>">
                                    <?php echo $this->atts['button_text'] ?>
                                </a>
                            </div>
                        <?php else : ?>
                            <a class="card__link" href="<?php echo $link; ?>"></a>
                        <?php endif; ?>
                        <div class="card__inner">
                            <div class="card_image">
                                <?php the_post_thumbnail('large'); ?>
                            </div>
                            <div class="card_caption">
                                <?php the_title() ?>
                            </div>
                            <?php if( $post_type == 'laniakea_swiper'):?>
                            <div class="card_content">
                                <?php the_content() ?>
                            </div>
                            <?php endif;?>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>

        <div class="swiper-pagination"></div>

        <figure class="swiper-button-prev"></figure>
        <figure class="swiper-button-next"></figure>

        <div class="swiper-scrollbar"></div>
    </div>
<?php endif; ?>


<script>
    function ready(fn) {
        if (document.readyState !== 'loading') {
            fn();
        } else {
            document.addEventListener('DOMContentLoaded', fn);
        }
    }

    const swiperOptions = <?php 
        if (!empty($swiper_json)) {
            echo $swiper_json;
        } else {
            echo "
            {
            speed: 400,
            slidesPerView: 1,
            spaceBetween: ".$this->atts['spacebetween'].",
            loop: ".$this->atts['loop'].",
            initialSlide: ".$this->atts['initialslide']." ,
            centeredSlides: false,
            centerInsufficientSlides: false,
            scrollbar: {
                enabled: false
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            freeMode: {
                enabled: true,
            },
            breakpoints: {
                1280: {
                    slidesPerView: 4
                },
                1024: {
                    slidesPerView: 3
                },
                768: {
                    slidesPerView: 2
                }
            },
        }";
        }

    ?>

    ready(function() {
        const swiper = new Swiper('.swiper', swiperOptions);

    });
</script>