<?php

function laniakea_option($k, $default = '')
{
    global $laniakea_options;
    if (empty(($laniakea_options))) {
        $laniakea_options =  get_option('laniakea_options');
    }
    if (isset($laniakea_options[$k]) && !empty($laniakea_options[$k])) return $laniakea_options[$k];
    else return $default;
}

function laniakea_get_logo($attachment_id, $default = '')
{
    if (!empty($attachment_id)) echo wp_get_attachment_url($attachment_id);
    else echo $default;
}

function laniakea_compress_css($css = '')
{
    if (!empty($css)) {
        $css = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $css);
        $css = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css);
        $css = str_replace(', ', ',', $css);
    }
    return $css;
}

function laniakea_get_googleapi_font()
{

    $font_weights = laniakea_option('font_weights', ['400', '700']);

    $has_italic = false;
    foreach ($font_weights as $key => $font) {
        if (substr($font, 0, 2) == '1,') {
            $has_italic = true;
            break;
        }
    }
    foreach ($font_weights as $key => $font) {
        if ($has_italic && substr($font, 0, 2) != '1,') {
            $font_weights[$key] = '0,' . $font;
        }
    }

    $family = laniakea_option('global_font', 'Raleway');
    $family .= $has_italic ? ':ital,wght' : ':wght';

    $weights = join(';', $font_weights);
    $href = sprintf("https://fonts.googleapis.com/css2?family=%s@%s&display=swap", $family, $weights);
    echo sprintf('<link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="%s" rel="stylesheet">', $href);
}

function laniakea_get_socials()
{
    return [
        [
            'label' => 'Facebook',
            'name' => 'facebook',
            'icon'  => 'fa-brands fa-facebook'
        ],
        [
            'label' => 'LinkedIn',
            'name' => 'linkedin',
            'icon'  => 'fa-brands fa-linkedin'
        ],
        [
            'label' => 'Instagram',
            'name' => 'instagram',
            'icon'  => 'fa-brands fa-instagram'
        ],
        [
            'label' => 'Youtube',
            'name' => 'youtube',
            'icon'  => 'fa-brands fa-youtube'
        ],
        [
            'label' => 'Vimeo',
            'name' => 'vimeo',
            'icon'  => 'fa-brands fa-vimeo'
        ],
        [
            'label' => 'Tik Tok',
            'name' => 'tiktok',
            'icon'  => 'fa-brands fa-tiktok'
        ],
        [
            'label' => 'Twitter',
            'name' => 'twitter',
            'icon'  => 'fa-brands fa-twitter'
        ],
        [
            'label' => 'Github',
            'name' => 'github',
            'icon'  => 'fa-brands fa-github'
        ],
        [
            'label' => 'Discord',
            'name' => 'discord',
            'icon'  => 'fa-brands fa-discord'
        ],
        [
            'label' => 'Stack Overflow',
            'name' => 'stack_overflow',
            'icon'  => 'fa-brands fa-stack-overflow'
        ],
        [
            'label' => 'Behance',
            'name' => 'behance',
            'icon'  => 'fa-brands fa-behance'
        ],
        [
            'label' => 'Spotify',
            'name' => 'spotify',
            'icon'  => 'fa-brands fa-spotify'
        ],
        [
            'label' => 'Soundcloud',
            'name' => 'soundcloud',
            'icon'  => 'fa-brands fa-soundcloud'
        ],
    ];
}

function laniakea_bakery_btn_colors()
{
    return [
        [
            'label' => 'Classic Grey',
            'value'  => 'default',
            'default' => '#ebebeb'
        ],
        [
            'label' => 'Classic Blue',
            'value'  => 'primary',
            'default' => '#0088cc'
        ],
        [
            'label' => 'Classic Turquoise',
            'value'  => 'info',
            'default' => '#58b9da'
        ],
        [
            'label' => 'Classic Green',
            'value'  => 'success',
            'default' => '#6ab165'
        ],
        [
            'label' => 'Classic Orange',
            'value'  => 'warning',
            'default' => '#ff9900'
        ],
        [
            'label' => 'Classic Red',
            'value'  => 'danger',
            'default' => '#ff675b'
        ],
        [
            'label' => 'Classic Black',
            'value'  => 'inverse',
            'default' => '#555555'
        ],
        [
            'label' => 'Blu',
            'value'  => 'blue',
            'default' => '#5472d2'
        ],
        [
            'label' => 'Turchese',
            'value'  => 'turquoise',
            'default' => '#00c1cf'
        ],
        [
            'label' => 'Pink',
            'value'  => 'pink',
            'default' => '#fe6c61'
        ],
        [
            'label' => 'Violet',
            'value'  => 'violet',
            'default' => '#8d6dc4'
        ],
        [
            'label' => 'Peacoc',
            'value'  => 'peacoc',
            'default' => '#4cadc9'
        ],
        [
            'label' => 'Chino',
            'value'  => 'chino',
            'default' => '#cec2ab'
        ],
        [
            'label' => 'Mulled Wine',
            'value'  => 'mulled-wine',
            'default' => '#50485b'
        ],
        [
            'label' => 'Vista Blue',
            'value'  => 'vista-blue',
            'default' => '#75d69c'
        ],
        [
            'label' => 'Nero',
            'value'  => 'black',
            'default' => '#2a2a2a'
        ],
        [
            'label' => 'Grigio',
            'value'  => 'grey',
            'default' => '#ebebeb'
        ],
        [
            'label' => 'Arancione',
            'value'  => 'orange',
            'default' => '#f7be68'
        ],
        [
            'label' => 'Sky',
            'value'  => 'sky',
            'default' => '#5aa1e3'
        ],
        [
            'label' => 'Verde',
            'value'  => 'green',
            'default' => '#6dab3c'
        ],
        [
            'label' => 'Juicy pink',
            'value'  => 'juicy-pink',
            'default' => '#f4524d'
        ],
        [
            'label' => 'Sandy brown',
            'value'  => 'sandy-brown',
            'default' => '#f79468'
        ],
        [
            'label' => 'Purple',
            'value'  => 'purple',
            'default' => '#b97ebb'
        ],
        [
            'label' => 'White',
            'value'  => 'white',
            'default' => '#ffffff'
        ]
    ];
}