<?php

function laniakea_factory_options()
{
    return  [
        //colori
        'primary_color' => '#5f68dd',
        'primary_text_color' => '#333333',
        'menu_hover_color' => '#5f68dd',
        'footer_color' => '#b5b5b5',
        'footer_bgcolor' => '#444444',
        'lower_footer_bgcolor' => '#444444',
        //tipografia
        'global_font' => 'Raleway',
        'font_weights' => ['400', '700'],
        //logo
        'logo_maxwidth' => 100,
        //header
        'show_preheader' => false,
        'menu_padding_top' => 24,
        'menu_padding_bottom' => 24,
        //footer
        'footer_copyright' => 'Laniakea corp. &copy;' . Date('Y'),
        //stickybar
        'show_stickybar' => 1,
        'stickybar_side' => 'right',
        'stickybar_top' => 30,
        'stickybar_slot1_link' => 'tel:1234567890',
        'stickybar_slot1_icon' => 'fa fa-phone',
        'stickybar_slot1_title' => 'contatti',
        'stickybar_slot2_link' => '/contatti',
        'stickybar_slot2_icon' => 'fa fa-envelope',
        'stickybar_slot2_title' => 'contattaci',
    ];
}

function laniakea_get_font_weights()
{
    return [
        [
            'value' => '100',
            'label' => 'Thin'
        ],
        [
            'value' => '200',
            'label' => 'Extra Light'
        ],
        [
            'value' => '300',
            'label' => 'Light'
        ],
        [
            'value' => '400',
            'label' => 'Regular'
        ],
        [
            'value' => '500',
            'label' => 'Medium'
        ],
        [
            'value' => '600',
            'label' => 'Semibold'
        ],
        [
            'value' => '700',
            'label' => 'Bold'
        ],
        [
            'value' => '800',
            'label' => 'ExtraBold'
        ],
        [
            'value' => '900',
            'label' =>  'Black'
        ]

    ];
}


function laniakea_tab_options()
{
    return [
        [
            'id' => 'generale',
            'icon' => 'globe',
            'label' => 'Generale'
        ],
        [
            'id' => 'colori',
            'icon' => 'palette',
            'label' => 'Colori'
        ],
        [
            'id' => 'bakery-buttons',
            'icon' => 'plug',
            'label' => 'Colore Pulsanti Bakery'
        ],
        [
            'id' => 'typography',
            'icon' => 'font',
            'label' => 'Tipografia'
        ],
        [
            'id' => 'logo',
            'icon' => 'star',
            'label' => 'Logo'
        ],
        [
            'id' => 'header',
            'icon' => 'bars',
            'label' => 'Header'
        ],
        [
            'id' => 'footer',
            'icon' => 'shoe-prints',
            'label' => 'Footer'
        ],

        [
            'id' => 'stickybar',
            'icon' => 'plug',
            'label' => 'Barra bordo'
        ],
        [
            'id' => 'griglie',
            'icon' => 'table-cells-large',
            'label' => 'Griglie'
        ],
        [
            'id' => 'social',
            'icon' => 'share',
            'label' => 'Socials'
        ],
        [
            'id' => 'iubenda',
            'icon' => 'cookie',
            'label' => 'Iubenda'
        ],
        [
            'id' => 'Google',
            'icon' => 'google fa-brands',
            'label' => 'Google'
        ]
    ];
}
