<?php

if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

$slider = is_front_page() ? laniakea_option('rev_slider') : '';
$laniakea_transparent_header =  get_post_meta($post->ID, 'laniakea_transparent_header', true);
$show_header_inverted = $slider || $laniakea_transparent_header;
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
  <meta charset="<?php echo esc_attr(get_bloginfo('charset')); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="profile" href="https://gmpg.org/xfn/11">
  <link rel="pingback" href="<?php esc_url(bloginfo('pingback_url')); ?>" />

  <?php laniakea_get_googleapi_font(); ?>
  <?php laniakea_gtm('head'); ?>
  <?php if (laniakea_option('manifest_active')== 1) laniakea_insert_manifest(); ?>
  <?php wp_head(); ?>

  <?php
  //IUBENDA:
  if (!empty(laniakea_option('iubenda_site_id'))) get_template_part('templates/iubenda/cookie', 'solutions');
  if (!empty(laniakea_option('iubenda_popup')))  get_template_part('templates/iubenda/popup', 'loader');
  ?>

</head>

<body <?php body_class(); ?>>

  <?php wp_body_open(); ?>
  <?php laniakea_gtm('body'); ?>
  <div id="wrapper">
    <header id="main-header" <?php if (!empty($show_header_inverted)) echo 'class="inverted"' ?>>
      <?php if (laniakea_option('show_preheader') == 1) get_template_part('templates/pre', 'header'); ?>

      <?php
      if (laniakea_option('show_stickybar') == 1) get_template_part('templates/sticky', 'bar');
      ?>

      <div class="header-container <?php if (laniakea_option('header_fullwidth') != 1) echo 'contained'; ?> d-flex align-center">
        <div id="logo">
          <a href="<?php echo esc_url(home_url()); ?>" aria-label="<?php echo esc_url(home_url()); ?>">
            <picture>
              <?php if (!empty(laniakea_option('primary_logo_mobile')) && !empty(laniakea_option('logo_break'))) : ?>
                <source media="(min-width: <?php echo laniakea_option('logo_break') ?>px)" srcset="<?php laniakea_get_logo(laniakea_option('primary_logo'), LANIAKEA_THEME_URI . 'logo.png') ?>" />
                <source media="(max-width: <?php echo laniakea_option('logo_break') ?>px)" srcset="<?php laniakea_get_logo(laniakea_option('primary_logo_mobile'), LANIAKEA_THEME_URI . 'logo.png') ?>" />
              <?php endif; ?>

              <img alt="" class="logo-default" src="<?php laniakea_get_logo(laniakea_option('primary_logo'), LANIAKEA_THEME_URI . 'logo.png') ?>" />
            </picture>
            <picture>
              <?php if (!empty(laniakea_option('inverted_logo_mobile')) && !empty(laniakea_option('logo_break'))) : ?>
                <source media="(min-width: <?php echo laniakea_option('logo_break') ?>px)" srcset="<?php laniakea_get_logo(laniakea_option('inverted_logo'), LANIAKEA_THEME_URI . 'logo.png') ?>" />
                <source media="(max-width: <?php echo laniakea_option('logo_break') ?>px)" srcset="<?php laniakea_get_logo(laniakea_option('inverted_logo_mobile'), LANIAKEA_THEME_URI . 'logo.png') ?>" />
              <?php endif; ?>

              <img alt="" class="logo-white" src="<?php laniakea_get_logo(laniakea_option('inverted_logo'), LANIAKEA_THEME_URI . 'logo-white.png') ?>" />
            </picture>
          </a>
        </div>
        <button class="mobile-burger" aria-label="menu">
          <svg width="50" height="50" viewBox="0 0 100 100">
            <path class="burger-line burger-line1" d="M 20,29.000046 H 80.000231 C 80.000231,29.000046 94.498839,28.817352 94.532987,66.711331 94.543142,77.980673 90.966081,81.670246 85.259173,81.668997 79.552261,81.667751 75.000211,74.999942 75.000211,74.999942 L 25.000021,25.000058" />
            <path class="burger-line burger-line2" d="M 20,50 H 80" />
            <path class="burger-line burger-line3" d="M 20,70.999954 H 80.000231 C 80.000231,70.999954 94.498839,71.182648 94.532987,33.288669 94.543142,22.019327 90.966081,18.329754 85.259173,18.331003 79.552261,18.332249 75.000211,25.000058 75.000211,25.000058 L 25.000021,74.999942" />
          </svg>
        </button>
        <nav class="main-nav nav-right">
          <?php
          $menu_args = array(
            'theme_location' => 'laniakea-header-menu',
            'depth' => 3,
            'container_class' => 'laniakea-menu',
            'menu_class' => 'nav-menu',
            'fallback_cb' => 'wp_page_menu'
          );
          wp_nav_menu($menu_args);
          ?>
        </nav>

      </div>
    </header>
    <?php



    if (!empty($slider)) : ?>
      <div class="rev-slider-container">
        <?php
        echo do_shortcode('[rev_slider alias="' . esc_attr($slider) . '"]');
        ?>
      </div>
    <?php endif; ?>