<?php

class LaniakeaBaseShortCode
{
    public $template;
    public $args;
    public $atts = [];
    public $shortname;

    public function __construct($shortname, $templatePath, $args)
    {
        $this->template = $templatePath;
        $this->shortname = $shortname;
        $this->args = is_callable($args)  ? $args() : $args;
        if ($this->args) {
            $this->atts =  $this->args['atts'];
        }

        add_shortcode($shortname, array($this, 'shortcodefn'));
    }

    function shortcodefn($atts)
    {
        $this->atts = shortcode_atts($this->atts, $atts, $this->shortname);

        $path =  LANIAKEA_THEME_DIR . 'core/shortcodes/templates/' . $this->template;

        if (is_file($path)) {
            ob_start();
            include $path;
            return ob_get_clean();
        }
    }
}
