const LaniakeaModule = (function ($) {
  function ready(fn) {
    if (document.readyState !== "loading") {
      fn();
    } else {
      document.addEventListener("DOMContentLoaded", fn);
    }
  }

  ready(onReady);

  function onReady() {
    const Wrapper = document.getElementById("wrapper");
    const docElem = document.documentElement;

    const header = document.querySelector("#main-header");
    const logo = document.querySelector("#main-header #logo");
    const mobileBurger = document.querySelector(".mobile-burger");
    const mainMenuLinks = document.querySelectorAll("#main-header .menu-item");

    const linesBurger = document.querySelectorAll(
      ".mobile-burger .burger-line"
    );
    const mainNav = document.querySelector(".main-nav");

    //widget
    const widgetSearch = document.querySelector(
      ".searchform input[type='submit']"
    );

    $(".blog_widget #s").each(function () {
      $(this).attr("placeholder", "Cerca");
    });

    if (widgetSearch) widgetSearch.value = "";

    //wrapper reset opacity on ready:
    Wrapper.style.opacity = 1;

    let didScroll = false;
    let changeHeaderOn = 50;

    function init() {
      window.addEventListener(
        "scroll",
        function (event) {
          if (!didScroll) {
            didScroll = true;
            setTimeout(scrollPage, 100);
          }
        },
        false
      );
      window.addEventListener(
        "load",
        function (event) {
          if (!didScroll) {
            didScroll = true;
            setTimeout(scrollPage, 100);
          }
        },
        false
      );

      mainMenuLinks.forEach((mnu) =>
        mnu.addEventListener("click", function () {
          if (window.location.href.indexOf("#") != -1) {
            document.body.classList.remove("menu-mobile-open");
          }
        })
      );

      mobileBurger.addEventListener("click", function (event) {
        document.body.classList.toggle("menu-mobile-open");

        if (document.body.classList.contains("menu-mobile-open")) {
          setTimeout(toggleLineBurgerWhite, 400);
        } else {
          toggleLineBurgerWhite();
        }
        mainNav.classList.toggle("visible-mobile");
      });
    }

    function toggleLineBurgerWhite() {
      linesBurger.forEach((el) => {
        el.classList.toggle("stroke-white");
      });
    }

    function scrollPage() {
      var sy = scrollY();
      if (sy >= changeHeaderOn) {
        header.classList.add("fixed");
      } else {
        header.classList.remove("fixed");
      }
      didScroll = false;
    }

    function scrollY() {
      return docElem.scrollTop;
    }

    init();

    $(document).on(
      "click",
      ".wpcf7-not-valid-tip,.wpcf7-response-output",
      function () {
        $(this).fadeOut();
      }
    );
  }
})(jQuery);
